<?= $this-> include('templates/header');?>
<?php 
use App\Libraries\TimeHelper; 
use App\Libraries\NumberFormatter;

?>
<main id="nsofts_main">
    <div class="nsofts-container">
        
        <?php 
            $cards = [
                ['title'=>'Categories', 'count'=>NumberFormatter::format($categoryTotalCount), 'icon'=>'ri-folder-3-line', 'bg'=>'bg-warning'],
                ['title'=>'Countries', 'count'=>NumberFormatter::format($countriesTotalCount), 'icon'=>'ri-global-line', 'bg'=>'bg-danger'],
                ['title'=>'Radio', 'count'=>NumberFormatter::format($radioTotalCount), 'icon'=>'ri-radio-2-line', 'bg'=>'bg-success'],
                ['title'=>'Podcast', 'count'=>NumberFormatter::format($podcastTotalCount), 'icon'=>'ri-disc-line', 'bg'=>'bg-info'],
                ['title'=>'Episode', 'count'=>NumberFormatter::format($episodeTotalCount), 'icon'=>'ri-music-2-line', 'bg'=>'bg-primary'],
                
                ['title'=>'Reports', 'count'=>NumberFormatter::format($reportsTotalCount), 'icon'=>'ri-feedback-line', 'bg'=>'bg-warning'],
                ['title'=>'Users', 'count'=>NumberFormatter::format($usersTotalCount), 'icon'=>'ri-folder-user-line', 'bg'=>'bg-danger'],
                ['title'=>'Admin', 'count'=>NumberFormatter::format($adminTotalCount), 'icon'=>'ri-admin-line', 'bg'=>'bg-success'],
            ];
        ?>
        
        <div class="row g-4">
            <?php foreach($cards as $card) : ?>
                <div class="col-xl-3 col-sm-6 col-12">
                    <div class="card card-badge">
                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <span class="h6 font-semibold text-muted text-sm d-block mb-2"><?= esc($card['title']); ?></span>
                                    <span class="h3 font-bold mb-0"><?= esc($card['count']); ?></span>
                                </div>
                                <div class="col-auto">
                                    <div class="icon-shape <?= esc($card['bg']); ?> text-white text-lg">
                                        <i class="<?= esc($card['icon']); ?>"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
            
        <div class="row g-4 mt-2">
            
            <div class="col-lg-7 col-md-6">
                <div class="card card-dashboard h-100">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="me-2">
                                <h5 class="mb-4">Users Analytics</h5>
                            </div>
                            <div class="d-inline-flex">
                                <form method="get" id="graphFilter">
                                <select class="form-control" name="filterByYear" style="width: 120px;" >
                                <?php 
                                    $currentYear=date('Y');
                                    $minYear=2023;
                                    for ($i=$currentYear; $i >= $minYear ; $i--) { 
                                ?>
                                <option value="<?=$i?>" <?=(isset($_GET['filterByYear']) && $_GET['filterByYear']==$i) ? 'selected' : ''?>><?=$i?></option>
                                <?php } ?>
                                </select>
                            </form>
                            </div>
                        </div>
                        <div style="height: 300px">
                            <?php if($no_data_status){ ?>
                                <h3 class="text-muted text-center" style="padding-bottom: 2em">No data found !</h3>
                            <?php } else{ ?>
                                <canvas id="nsofts_analytics"></canvas>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>   
            
            <div class="col-lg-5 col-md-6">
                <div class="card card-dashboard h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">New Reports</h5>
                        </div>
                        <?php if(!empty($result)){ ?>
                        
                            <?php $i=0; foreach($result as $row){ ?>
                            
                                <div class="d-flex align-items-center mt-4">
                                    <span class="d-block fw-semibold"><?php echo $row['report_title'];?></span>
                                    <span><td><?= esc(TimeHelper::calculateTimeSpan($row['report_on'])); ?></td></span>
                                </div>
                                
                            <?php $i++; } ?> 
                            
                        <?php } else { ?>
                            <ul class="p-2">
                                <h3 class="text-center">No data found !</h3>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            </div> 
        </div>
        
    </div>
</main>
<?= $this-> include('templates/footer');?>

<?php if(!$no_data_status){ ?>
    <script>
        const isDarkMode = function() {
            return localStorage.getItem('dark_mode') === 'true';
        }
        
        const getCSSVarValue = function(name) {
            let hex = getComputedStyle(document.documentElement).getPropertyValue('--ns-' + name);
            if (hex && hex.length > 0) {
                hex = hex.trim();
            }
            return hex;
        }
        
        if (Chart) {
            const defaults = Chart.defaults;
            const config = {
                color: isDarkMode() ? '#fff' : getCSSVarValue('body-color'),
                borderColor: isDarkMode() ? '#2d2f32' : getCSSVarValue('gray-10'),
                
                // Chart typo
                font: {
                    family: getCSSVarValue('body-font-family'),
                    size: 13
                },
            };
            
            Object.assign(defaults, config);
        }
        
        const canvas = document.getElementById('nsofts_analytics');
        if (canvas) {
            const config = {
                type: 'line',
                data: {
                    
                    labels: <?php echo "[".$monthStr."]";?>,
                    datasets: [
                        {
                            label: 'Users',
                            data: <?php echo "[".$countStr."]";?>,
                            backgroundColor: getCSSVarValue('primary'),
                            borderColor: getCSSVarValue('primary'),
                            tension: 0.1
                        }
                    ]
                },
                options: {
                    title: {
                        display: false,
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            min: 0,
                            
                            grid: {
                                borderColor: isDarkMode() ? '#2d2f32' : getCSSVarValue('gray-10'),
                            }
                        },
                        x: {
                            grid: {
                                borderColor: isDarkMode() ? '#2d2f32' : getCSSVarValue('gray-10'),
                            }
                        }
                    },
                    layout: {
                        margin: 0,
                        padding: 0
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                    }
                }
            };
            analyticsChart = new Chart(canvas, config);
        }
    </script>
<?php } ?>
<script>
  document.querySelector("select[name='filterByYear']").addEventListener("change", function() {
    document.getElementById("graphFilter").submit();
  });
</script>